% A 2.5: Impuls- und Sprungantwort im eines einfachen Systems 1.Ordnung
% Vergleich zwischen zeitdiskret und -kontinuierlich
% bung Signalverarbeitung, 19.04.2011

clear all % leeren des workspace
close all % alle plots schlieen
clc % leeren des comand window


% Je feiner abgetastet wird, desto genauer stimmt diskret und
% kontinuierlich miteinander berein.
T0   = 0.05;  % Abtastzeit [s]


tmax = 10; % Endzeit [s]
kmin = 0; % erster Abtastpunkt
kmax = floor(tmax / T0); % letzter Abtastpunkt


% Definition der Eingangsgre
impuls = [1/T0 zeros(1,kmax)];   % Einheitsimpuls
sprung = ones(1,kmax+1);         % Einheitssprung

u = sprung; % wahl des Eingangssignals


% Parameter der Differenzengleichung: y(k) = b0*u(k) + a0*y(k-1)
% mit a = 1 und b = 1.
b0 = T0/(1+T0);
a1 = 1/(1+T0);

% Anfangswerte
y(1) = b0*u(1);
y(2) = b0*u(2)+a1*y(1);

% Rekursive Berechnung
for k = kmin+2:kmax+1
   y(k) = b0*u(k)+a1*y(k-1); % Antwort des Systems erster Ordnung
end


%%%%%%%%%%%%%%%
% Darstellung %
%%%%%%%%%%%%%%%

figure(1)
k = kmin:kmax; % Diskreter Zeitvektor k = t/T0
tc = linspace(0,tmax,300); % Pseudo-kontinuierlicher Zeitvektor in [sec]
if u==impuls
    yc = exp(-tc); % kontinuierliche Impulseantwort
else
    yc = 1-exp(-tc); % kontinuierliche Sprungantwort
end
% kontinuierliches Signal darstellen
plot(tc,yc,'linewidth',1.5)
hold on
% diskretes Signal darstellen
plot(k*T0,y,'r-o','linewidth',1.5,'markersize',5)
set(gca,'fontsize',13)
xlabel('Zeit t [sec]','fontsize',13)
ylabel('Systemantwort','fontsize',13)




